Attribute VB_Name = "mod_data"
Option Explicit

Const numFix = 199
Public WDAT(numFix) As String

Public MissingFixes(200) As String


Public Function wdatLookup(fixname As String) As String

Dim i As Long
Dim fn As String
Dim res As String

For i = 0 To numFix - 1
    fn = getToken(WDAT(i), 1, ",")
    If (fn = fixname) Then
        wdatLookup = WDAT(i)
        Exit Function
    End If
Next

If ((InStr(fixname, "/") > 0) And (Len(fixname) = 5)) Then 'in the format 40/50
    fn = fixname & "," & Left(fixname, 2) & ",-" & Right(fixname, 2)
    wdatLookup = fn
    Exit Function
End If

If (Len(fixname) = 4) Then 'oceanic fix in the format 4050
    fn = fixname & "," & Left(fixname, 2) & ",-" & Right(fixname, 2)
    wdatLookup = fn
    Exit Function
End If


'if you get there then fixname is unidentified

Dim flag As Boolean
flag = False

For i = 0 To 200 - 1
    If (MissingFixes(i) = fixname) Then
        flag = True
        Exit For
    End If
Next i
If (Not flag) Then
    For i = 0 To 200 - 1
        If (MissingFixes(i) = "") Then
            MissingFixes(i) = fixname
            logthis ("Unidentified Waypoint: " & fixname)
            Form1.listHistory.AddItem Format(GetGmtTime, "hhnn") & " UNID WPT " & fixname
            Form1.listHistory.ListIndex = Form1.listHistory.ListCount - 1 'selects the last item
            Exit For
        End If
    Next
End If
wdatLookup = ""



End Function


Public Sub loadWDAT()

WDAT(0) = "ALMES,58.5000,-63.0000"
WDAT(1) = "ATSIX,60.0000,-10.0000"
WDAT(2) = "AY,51.3863,-56.0963"
WDAT(3) = "BABAN,54.0000,-12.0000"
WDAT(4) = "BAGIT,61.0000,-15.0000"
WDAT(5) = "BALIX,59.0000,-10.0000"
WDAT(6) = "BANCS,45.6500,-52.1033"
WDAT(7) = "BEDRA,49.0000,-15.0000"
WDAT(8) = "BERUS,63.0000,-63.0000"
WDAT(9) = "BERUX,45.0000,-11.0000"
WDAT(10) = "BILPO,59.0000,-63.0000"
WDAT(11) = "BOBTU,44.1172,-52.8222"
WDAT(12) = "BOS,42.3643,-71.0052"
WDAT(13) = "BURAK,53.0000,-12.0000"
WDAT(14) = "CARAC,43.0000,-60.0000"
WDAT(15) = "CARPE,53.0833,-54.0833"
WDAT(16) = "CIMAT,59.5000,-63.0000"
WDAT(17) = "COLOR,46.6683,-52.5022"
WDAT(18) = "COPUR,59.7003,-67.0097"
WDAT(19) = "CRONO,51.3889,-52.7222"
WDAT(20) = "CYMON,49.7167,-55.0000"
WDAT(21) = "DENDU,50.5056,-52.0694"
WDAT(22) = "DEVOL,53.8950,-10.4347"
WDAT(23) = "DF,49.1800,-57.4572"
WDAT(24) = "DINIM,51.0000,-15.0000"
WDAT(25) = "DIXIS,45.0000,-10.0000"
WDAT(26) = "DOGAL,54.0000,-15.0000"
WDAT(27) = "DOLIP,52.0000,-12.0000"
WDAT(28) = "DOPHN,44.5500,-55.4833"
WDAT(29) = "DOTTY,50.6333,-55.5833"
WDAT(30) = "DUMRO,60.0000,-63.0000"
WDAT(31) = "ELPIN,56.0000,-12.0000"
WDAT(32) = "ELSET,60.5000,-63.0000"
WDAT(33) = "ERAKA,58.0000,-10.0000"
WDAT(34) = "ETARI,55.5000,-15.0000"
WDAT(35) = "ETIKI,48.0000,-8.7500"
WDAT(36) = "ETSOM,57.8978,-9.5000"
WDAT(37) = "FASSA,58.7003,-67.0097"
WDAT(38) = "FEDDY,61.7000,-67.0000"
WDAT(39) = "FLEXE,61.0000,-63.0000"
WDAT(40) = "FOXXE,54.4864,-59.2869"
WDAT(41) = "GINGA,56.9306,-9.5000"
WDAT(42) = "GIPER,51.0000,-12.0000"
WDAT(43) = "GOMUP,57.0000,-10.0000"
WDAT(44) = "GRIBS,61.5000,-63.0000"
WDAT(45) = "GUNSO,49.0703,-11.7442"
WDAT(46) = "HECKK,52.2222,-53.3694"
WDAT(47) = "HEMMI,45.0594,-55.5342"
WDAT(48) = "HIDRA,44.5000,-13.0000"
WDAT(49) = "HO,55.4639,-60.2139"
WDAT(50) = "IKMAN,62.5000,-63.0000"
WDAT(51) = "JAROM,44.1667,-54.8842"
WDAT(52) = "JEBBY,43.0675,-57.8669"
WDAT(53) = "JELCO,60.7000,-67.0000"
WDAT(54) = "JFK,40.6329,-73.7714"
WDAT(55) = "JT,48.5438,-58.7547"
WDAT(56) = "KAGLY,63.5000,-63.0000"
WDAT(57) = "KEF,63.9894,-22.6242"
WDAT(58) = "KENKI,65.0000,-63.0000"
WDAT(59) = "KENRI,59.0000,-60.8767"
WDAT(60) = "KENUK,50.0000,-12.0000"
WDAT(61) = "KOBEV,49.6722,-51.4667"
WDAT(62) = "KORIB,54.2556,-13.0000"
WDAT(63) = "LAKES,57.9858,-63.2667"
WDAT(64) = "LAPEX,47.0000,-8.0000"
WDAT(65) = "LIMRI,52.0000,-15.0000"
WDAT(66) = "LOACH,55.5167,-57.0156"
WDAT(67) = "LOGSU,48.7833,-51.0000"
WDAT(68) = "LOMTA,57.2033,-62.6200"
WDAT(69) = "LON,51.4686,-.4514"
WDAT(70) = "LOPVI,59.2667,-64.2500"
WDAT(71) = "MALOT,53.0000,-15.0000"
WDAT(72) = "MASIT,54.3333,-12.0000"
WDAT(73) = "MIBNO,65.5833,-62.5333"
WDAT(74) = "MIMKU,56.0000,-10.0000"
WDAT(75) = "MOATT,58.0250,-59.9283"
WDAT(76) = "MORAG,55.8561,-9.5000"
WDAT(77) = "MUDOS,43.5000,-13.0000"
WDAT(78) = "MUSVA,64.0000,-63.0000"
WDAT(79) = "MY,62.1068,-7.5877"
WDAT(80) = "NALDI,64.5000,-63.0000"
WDAT(81) = "NIBOG,55.0000,-10.0000"
WDAT(82) = "NOVEP,47.8361,-51.0000"
WDAT(83) = "NURSI,54.9703,-9.5000"
WDAT(84) = "ODLUM,55.0000,-12.0000"
WDAT(85) = "OMOKO,48.8425,-12.0000"
WDAT(86) = "OYSTR,53.8750,-54.9722"
WDAT(87) = "OZN,60.0572,-43.1597"
WDAT(88) = "PASAS,45.0000,-13.0000"
WDAT(89) = "PEPKI,59.7333,-61.6167"
WDAT(90) = "PIK,55.5062,-4.5773"
WDAT(91) = "PIKIL,56.0000,-15.0000"
WDAT(92) = "PIKIL,56.0000,-15.0000"
WDAT(93) = "PORGY,56.3167,-58.0822"
WDAT(94) = "PRAWN,57.2056,-59.1889"
WDAT(95) = "QX,48.9650,-54.6683"
WDAT(96) = "RAFIN,44.8833,-51.8050"
WDAT(97) = "RASIX,43.0000,-13.0000"
WDAT(98) = "RATSU,61.0000,-10.0000"
WDAT(99) = "REDBY,52.2492,-56.6014"
WDAT(100) = "REGHI,48.0000,-8.0000"
WDAT(101) = "RESNO,55.0000,-15.0000"
WDAT(102) = "RIBNO,60.0833,-65.1667"
WDAT(103) = "RIVAK,46.0000,-8.0000"
WDAT(104) = "RODBO,60.0833,-65.1667"
WDAT(105) = "RONPO,46.8833,-51.0000"
WDAT(106) = "SCROD,54.6167,-55.8667"
WDAT(107) = "SEPAL,47.0000,-8.7500"
WDAT(108) = "SHA,52.7175,-8.8836"
WDAT(109) = "SIVIR,46.0000,-8.7500"
WDAT(110) = "SOMAX,50.0000,-15.0000"
WDAT(111) = "STEAM,52.9983,-57.3417"
WDAT(112) = "SUNOT,57.0000,-15.0000"
WDAT(113) = "SUNOT,57.0000,-15.0000"
WDAT(114) = "TADEX,54.8564,-8.2333"
WDAT(115) = "TANTI,62.0000,-63.0000"
WDAT(116) = "TAPLU,60.0000,-61.9017"
WDAT(117) = "TEFFO,62.8000,-67.0000"
WDAT(118) = "TULTA,48.5839,-8.0000"
WDAT(119) = "UHA,61.0427,-69.6273"
WDAT(120) = "URTAK,45.8417,-51.0000"
WDAT(121) = "VALIE,53.6250,-58.1389"
WDAT(122) = "VENER,54.5000,-15.0000"
WDAT(123) = "VIBDI,58.8833,-60.7500"
WDAT(124) = "VIMLA,61.0000,-63.0000"
WDAT(125) = "VIXUN,48.1383,-53.6133"
WDAT(126) = "VODOR,44.9389,-51.0000"
WDAT(127) = "VP,58.0562,-68.4863"
WDAT(128) = "YAY,51.3939,-56.0839"
WDAT(129) = "YDF,49.2325,-57.2133"
WDAT(130) = "YDP,56.5333,-61.6917"
WDAT(131) = "YFB,63.7417,-68.4733"
WDAT(132) = "YFY,63.7333,-68.5480"
WDAT(133) = "YJI,67.5620,-64.0175"
WDAT(134) = "YJT,48.5825,-58.6692"
WDAT(135) = "YQX,48.9000,-54.5350"
WDAT(136) = "YR,53.3378,-60.3658"
WDAT(137) = "YT,47.6700,-52.8083"
WDAT(138) = "YVP,58.0961,-68.4272"
WDAT(139) = "YXP,66.1438,-65.7062"
WDAT(140) = "YYR,53.3197,-60.2947"
WDAT(141) = "YYT,47.4850,-52.8517"
WDAT(142) = "NETKI,55,-14"      'Missing fixes
WDAT(143) = "BEXET,54,-14"
WDAT(144) = "GISTI,53,-14"
WDAT(145) = "XETBO,52,-14"
WDAT(146) = "ELSOX,51,-14"
WDAT(147) = "SOORY,38.5,-60.267"
WDAT(148) = "ATSUR,50,-14"
WDAT(149) = "BALOO,34.41,-62.14"
WDAT(150) = "LAZEY,33.59,-61.49"
WDAT(151) = "NERTU,49,-14"
WDAT(152) = "UPGAS,51.4,-3.83"
WDAT(153) = "MERLY,51.33,-5"
WDAT(154) = "LESLU,50.42,-8"
WDAT(155) = "MALBY,51.59,-2.04"
WDAT(156) = "SM15W,50.683,-15.000" 'Concorde Routes
WDAT(157) = "SM20W,50.833,-20.000"
WDAT(158) = "SM30W,50.500,-30.000"
WDAT(159) = "SM40W,49.267,-40.000"
WDAT(160) = "SM50W,47.050,-50.000"
WDAT(161) = "SM53W,46.167,-53.000"
WDAT(162) = "SM60W,44.233,-60.000"
WDAT(163) = "SM65W,42.767,-65.000"
WDAT(164) = "SM67W,42.000,-67.000"
WDAT(165) = "SN67W,40.417,-67.000"
WDAT(166) = "SN65W,41.667,-65.000"
WDAT(167) = "SN60W,43.117,-60.000"
WDAT(168) = "SN52W,45.167,-52.500"
WDAT(169) = "SN50W,45.900,-50.000"
WDAT(170) = "SN40W,48.167,-40.000"
WDAT(171) = "SN30W,49.433,-30.000"
WDAT(172) = "SN20W,49.817,-20.000"
WDAT(173) = "SN15W,49.683,-15.000"
WDAT(174) = "SO15W,48.667,-15.000"
WDAT(175) = "SO20W,48.800,-20.000"
WDAT(176) = "SO30W,48.367,-30.000"
WDAT(177) = "SO40W,47.067,-40.000"
WDAT(178) = "SO50W,44.750,-50.000"
WDAT(179) = "SO52W,44.167,-52.000"
WDAT(180) = "SO60W,42.000,-60.000"
WDAT(181) = "SOCA,48.983,-14.717"
WDAT(182) = "SP20W,46.817,-20.000"
WDAT(183) = "SP45N,45.000,-23.883"
WDAT(184) = "SP30W,41.600,-30.000"
WDAT(185) = "SP40W,34.367,-40.000"
WDAT(186) = "DOVEY,41.12,-67.000" 'Missing fixes
WDAT(187) = "JOBOC,40.12,-67.000"
WDAT(188) = "NUMBR,32.67,-61.192"
WDAT(189) = "SLATN,39.12,-67.000"
WDAT(190) = "WINGZ,31.64,-61.29"
WDAT(191) = "BILTO,56.5,-15"
WDAT(192) = "SOVED,56,-14"
WDAT(193) = "AGORI,57,-13"
WDAT(194) = "ELFIN,37.86,-97.12"
WDAT(195) = "KESIX,56.95,-14"
WDAT(196) = "MIBNO,60.57,-62.52"
WDAT(197) = "TALGO,44.1675,-52.4355"
WDAT(198) = "STG,42.9275,-8.4258"





End Sub

